@extends('admin.layout.master')
@section('import-css')
    <link href="{{ asset('assets/admin/css/bootstrap-fileinput.css') }}" rel="stylesheet">
    <link rel="stylesheet" href=" {{ asset('assets/front/css/fontawesome.min.css') }} ">
    <link rel="stylesheet" href="{{asset('assets/front/css/flaticon.css')}}">
    <link rel="stylesheet" href="{{asset('assets/front/css/flaticon2.css')}}">
@stop
@section('body')

    <div class="card mb-4 margin-bottom-50">
        <div class="card-header ">
            <h4 class="card-title">{{$page_title}}

                <button class="btn btn-success btn-md float-right" data-toggle="modal" data-target="#addModal">
                    <i class="fa fa-plus"></i> Create New
                </button>
            </h4>
        </div>

        {!! Form::model($basic,['route'=>['manage-footer-update'],'method'=>'PUT','role'=>'form','class'=>'form-horizontal','files'=>true]) !!}

        <div class="card-body">

            <div class="row">
                <div class="col-md-12">

                    <div class="form-group{{ $errors->has('event_h') ? ' has-error' : '' }}">
                        <label class="col-md-12"><strong class="text-uppercase"> Title</strong></label>
                        <div class="col-md-12">
                            <input type="text" name="event_h" class="form-control form-control-lg" value="{{ $basic->event_h }}" required >
                            @if ($errors->has('event_h'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('event_h') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>

                    <div class="form-group{{ $errors->has('event_p') ? ' has-error' : '' }}">
                        <label class="col-md-12"><strong class="text-uppercase">Details</strong></label>
                        <div class="col-md-12">
                            <textarea name="event_p" class="form-control" rows="3" required>{{ $basic->event_p }}</textarea>
                            @if ($errors->has('event_p'))
                                <span class="help-block">
                                    <strong>{{ $errors->first('event_p') }}</strong>
                                </span>
                            @endif
                        </div>
                    </div>

                </div>
            </div><!-- row -->

        </div>
        <div class="card-footer ">
            <button class="btn btn-primary btn-block btn-lg" type="submit"> <i class="fa fa-send"></i> Update</button>
        </div>

        {!! Form::close() !!}
    </div>



    @include('errors.error')

    <div class="row">
        @foreach($ourEvent as $key => $data)
            <div class="col-md-3    ">
                <div class="card">
                    <div class="card-body text-center">
                        <h5 class="card-title mb-4"> {{$data->title}}</h5>
                       <h4 style="font-size: 40px"> {!! $data->icon !!}</h4>
                        <p class="card-text mt-3">{{$data->details}}</p>
                    </div>

                    <div class="card-footer bg-white text-center">
                        <button class="btn btn-danger delete_button" data-toggle="modal" data-target="#DelModal" data-id="{{ $data->id }}">
                            <i class="fa fa-trash"></i> Delete
                        </button>
                    </div>
                </div>
                <br>
            </div>
        @endforeach
    </div>




    <div class="modal fade editModal" id="addModal" tabindex="-1"
         role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">

                <div class="modal-header">
                    <h4 class="modal-title" id="myModalLabel">Add <strong>New Event</strong></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times; </button>
                </div>
                <form method="post" action="{{route('store.event')}}" enctype="multipart/form-data">
                    {{ csrf_field() }}

                    <div class="modal-body">
                        <div class="form-group">
                            <h6><strong>Title</strong></h6>
                            <input type="text" class="form-control form-control-lg" id="title" name="title" value="{{old('title')}}">
                        </div>
                        <div class="form-group">
                            <h6><strong>Icon</strong></h6>
                            <input type="text" class="form-control form-control-lg" id="icon" name="icon" value="{{old('icon')}}">
                            <code>you can use fontawesome icon </code>
                        </div>
                        <div class="form-group">
                            <h6><strong>Details</strong></h6>
                            <textarea name="details"  rows="3" class="form-control form-control-lg">{{old('details')}}</textarea>
                        </div>


                    </div>

                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success ">Save Changes</button>
                        <button type="button" class=" btn btn-danger" data-dismiss="modal"
                                aria-hidden="true">Close
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <div class="modal fade" id="DelModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content" >
                <div class="modal-header">
                    <h4 class="modal-title" id="myModalLabel2"><i class='fa fa-trash'></i> Delete !</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">
                    <strong>Are you sure you want to Delete ?</strong>
                </div>

                <div class="modal-footer">
                    <form method="post" action="{{ route('delete.event') }}" >
                        {!! csrf_field() !!}
                        {{ method_field('DELETE') }}
                        <input type="hidden" name="id" class="abir_id" value="0">

                        <button type="submit" class="btn btn-success"><i class="fa fa-check"></i> Yes</button>

                        <button type="button" class="btn btn-danger" data-dismiss="modal"><i class="fa fa-trash"></i> No</button>&nbsp;
                    </form>
                </div>

            </div>
        </div>
    </div>

@stop
@section('script')
    <script>
        $(document).ready(function () {
            $(document).on("click", '.delete_button', function (e) {
                var id = $(this).data('id');
                $(".abir_id").val(id);
            });
        });
    </script>
@stop